<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Stichoza\GoogleTranslate\GoogleTranslate;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var string[]
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var string[]
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request, Throwable $e)
    {
        // dd($e->getCode());
        if($e->getCode()== 400){
            return response()->json(['messege' => GoogleTranslate::trans($e->getMessage(),'uz')], 400);
        }
        else if($e->getMessage()== 401){
            return response()->json(['messege' => "Sizga ruxsat yoq"], 401);
        }
        else if($e->getCode()== 403){
            return response()->json(['messege' => "Ruxsat aktiv emas"], 403);
        }
        else if ($e->getMessage()!="") {
            return response()->json(['messege' => $e->getMessage() ], 500);
        }
        return response()->json(['messege' => "Sahifa topilmadi"], 404);
    }
}
