<?php

namespace App\Http\Controllers;

use App\Models\Notice;
use App\Models\TelegramNotification;
use App\Notifications\BackupDatabase;
use Illuminate\Http\Request;
use Ifsnop\Mysqldump\Mysqldump;
use Illuminate\Support\Facades\Config;

class BackupController extends Controller
{
    public function index()
    {
        try {
            $dump = new Mysqldump('mysql:host=localhost;dbname=' . env('DB_DATABASE'), env('DB_USERNAME'), env('DB_PASSWORD'));

            $folder = public_path('/') . date('Y-m-d', time()) . ' ' . env('DB_DATABASE') . '.sql';

            $dump->start($folder);


            $obj = new TelegramNotification([
                'telegramid' => Config::get('services.telegram_id'),
                'noticelink' => $folder
            ]);
            $obj->notify(new BackupDatabase());

            if (file_exists($folder)) {
                unlink($folder);
            }

            return "Muvaffaqiyatli BackUp olindi";
        } catch (\Exception $e) {
            echo 'mysqldump-php error: ' . $e->getMessage();
        }
    }
}
