<?php

namespace App\Http\Controllers;

use App\Models\CommissionGroup;
use App\Models\Group;
use App\Models\Student;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CommissionGroupController extends Controller
{
    public function view(Request $request)
    {
        $user = $this->getUser($request);
        $array_delete_commission = CommissionGroup::where('user_id', $user->id)->where('status','passive')
            ->pluck('group_id')
            ->toArray();
        $array_group_ids = CommissionGroup::where('user_id', $user->id)->whereNotIn('group_id',$array_delete_commission)
            ->pluck('group_id')
            ->toArray();

        $groups = Group::select(
            DB::raw(
                'direction.name as direction_name , group.id as id , group.date as date , group.type as type'
            )
        )
            ->leftJoin('direction', 'direction.id', '=', 'group.direction_id')
            ->where('group.status', 'doing')
            ->whereIn('group.id', $array_group_ids) // where('direction.status','active')
            ->orderByDesc('group.id')
            ->get();

        $group_json = [];

        if ($groups) {
            foreach ($groups as $group) {
                $json = [];
                $group_object = (object) [];

                $students = Student::select(
                    DB::raw(
                        'id,name,type,status,round(professional_ball + online_test_ball , 3) as result'
                    )
                )
                    ->where('group_id', $group->id)
                    ->where('status', '!=', 'delete')
                    ->where('professional_ball','!=',30)
                    ->having('result', '>=', 44.8)
                    ->get();

                


                $group_object->id = $group->id;
                $group_object->name =
                    date('m.Y', $group->date) .
                    ' - ' .
                    date('m.Y', $group->date_end) .
                    ' ' .
                    $group->direction_name;
                if($group->type){
                     $group_object->name =
                date('m.Y', $group->date) .
                ' - ' .
                date('m.Y', $group->date_end) .
                ' ' . $group->type.'.'.
                $group->direction_name;
                }
                foreach ($students as $student) {
                    $object = (object) [];
                    $object->id = $student->id;
                    $object->name = $student->name;
                    $object->result = $student->result;
                    if ($student->type) {
                        $type = $this->array(json_decode($student->type), 'id');
                        if (in_array($user->id, $type)) {
                            $object->status = 'done';
                        } else {
                            $object->status = 'doing';
                        }
                    } else {
                        $object->status = 'doing';
                    }

                    $json[] = $object;
                }
                $group_object->student = $json;

                $group_json[] = $group_object;
            }
        }

        return $group_json;
    }
}
