<?php

namespace App\Http\Controllers;

use App\Models\Direction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class DirectionController extends Controller
{
    public function view()
    {
        $direction = Direction::orderByDesc('id')->where('status','active')->paginate(10);
        $object = (object) [];
        $object->data = $direction->getCollection();
        $object->total = $direction->total();
        $object->current_page = $direction->currentPage();
        

        return $object;
    }

    public function select()
    {
      return Direction::orderByDesc('id')->where('status','active')->get();
    }

    public function create(Request $request, $id = null)
    {
        if ($id) {
            $this->validationId('direction', $id);
            $direction = Direction::find($id);

            $direction->name = $request->name;
            $direction->save();

            return response([
                'message' => "Yo'nalish o'zgartirildi",
            ]);
        }

        $direction = new Direction();

        $validator = FacadesValidator::make($request->all(), $direction->rules);

        if ($validator->fails()) {
            $this->error($validator->errors(), 400);
        }

        Direction::create($request->all());


        return response([
            'message' => "Yo'nalish yaratildi",
        ]);
    }
}
