<?php

namespace App\Http\Controllers;

use App\Models\CommissionGroup;
use App\Models\Criteria;
use App\Models\Direction;
use App\Models\Group;
use App\Models\Student;
use App\Models\StudentBall;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;

class DocumentController extends Controller
{
    public function download($id)
    {
        // # pdf download
        $this->validationId('group', $id);

        $title = (object) [];
        $group = Group::find($id);
        $direction = Direction::find($group->direction_id);

        $file_name = $group->date . ' ' . $direction->name . '.pdf';

        $year = explode('-', $group->date)[1];
        $mount1 = $this->getMounthName(explode('-', $group->date)[0]);
        $mount2 = $this->getMounthName(explode('-', $group->date)[0] + 1);

        $title->title = $direction->name;
        $title->date = $year . '-yil ' . $mount1 . '-' . $mount2 . ' ';
        $students = Student::select(
            DB::raw(
                'id, round(professional_ball + online_test_ball , 3) as result'
            )
        )
            ->where('group_id', $group->id)
            ->where('status', '!=', 'delete')
            ->where('again', 0)
            ->having('result', '>=', 44.8)
            ->get();

        $ids = $this->array($students, 'id');

        $studentss = Student::where('group_id', $group->id)
            ->where('status', '!=', 'delete')
            ->where('again', 0)
            ->where('professional_ball', 30)
            ->orWhereIn('id', $ids)
            ->orderByDesc('id')
            ->get();

        $students_again = Student::select(
            DB::raw(
                'id, round(professional_ball + online_test_ball , 3) as result'
            )
        )
            ->where('group_id', $group->id)
            ->where('status', '!=', 'delete')
            ->where('again', 1)
            ->having('result', '>=', 44.8)
            ->get();

        $ids = $this->array($students_again, 'id');

        $studentss_again = Student::where('group_id', $group->id)
            ->where('status', '!=', 'delete')
            ->where('again', 1)
            ->where('professional_ball', 30)
            ->orWhereIn('id', $ids)
            ->orderByDesc('id')
            ->get();

        $commissions = CommissionGroup::leftjoin(
            'user',
            'user.id',
            '=',
            'commission_group.user_id'
        )
            ->where('commission_group.group_id', $id)
            ->where('user.role', 'commission')
            ->where('commission_group.status', 'active')
            ->get();

        $criterias = Criteria::get();
        $string = '';

        $i = 1;

        $students = [];
        foreach ($studentss as $student) {
            $commission_count = 1;
            if ($student->type) {
                $commission_count = count(json_decode($student->type));
            }
            $object = (object) [];
            $object->name = $student->name;
            $object->professional_ball = $student->professional_ball;
            $object->online_test_ball = $student->online_test_ball;
            $son = round(
                StudentBall::where('student_id', $student->id)->sum('ball') /
                    $commission_count,
                2
            );
            $cri = StudentBall::where('student_id', $student->id)->first();

            $object->cri = false;

            if ($cri) {
                $object->cri = true;
            }
            $object->average = $son;

            $jami = 0;
            $all_son = 0;
            $j = 1;
            foreach ($criterias as $criteria) {
                $val = 'ball_' . $j;
                $ball = StudentBall::where('student_id', $student->id)
                    ->where('criteria_id', $criteria->id)
                    ->first();
                if ($ball) {
                    $son = round(
                        StudentBall::where('student_id', $student->id)
                            ->where('criteria_id', $criteria->id)
                            ->sum('ball') / $commission_count,
                        2
                    );

                    $all_son += $son;
                    $object->$val = $son;
                }

                $j++;
            }

            $jami =
                $all_son +
                $student->professional_ball +
                $student->online_test_ball;

            $object->all_sum = $jami;
            $object->sum = $all_son;
            $i++;
            $students[] = $object;
        }

        $agains_students = [];
        foreach ($studentss_again as $student) {
            $object = (object) [];
            $object->name = $student->name;
            $object->professional_ball = $student->professional_ball;
            $object->online_test_ball = $student->online_test_ball;
            $son = round(
                StudentBall::where('student_id', $student->id)->sum('ball') /
                    $commission_count,
                2
            );
            $cri = StudentBall::where('student_id', $student->id)->first();

            $object->cri = false;

            if ($cri) {
                $object->cri = true;
            }
            $object->average = $son;

            $jami = 0;
            $all_son = 0;
            $j = 1;
            foreach ($criterias as $criteria) {
                $val = 'ball_' . $j;
                $ball = StudentBall::where('student_id', $student->id)
                    ->where('criteria_id', $criteria->id)
                    ->first();
                if ($ball) {
                    $son = round(
                        StudentBall::where('student_id', $student->id)
                            ->where('criteria_id', $criteria->id)
                            ->sum('ball') / $commission_count,
                        2
                    );

                    $all_son += $son;
                    $object->$val = $son;
                }

                $j++;
            }

            $jami =
                $all_son +
                $student->professional_ball +
                $student->online_test_ball;

            $object->all_sum = $jami;
            $object->sum = $all_son;
            $i++;
            $agains_students[] = $object;
        }

        $rais = User::where('role', 'director')
            ->where('type', 'rais')
            ->first();

        $rais_assistant = User::where('role', 'director')
            ->where('type', 'assistant')
            ->when($id>265,function($q){
                $q->where('status','active');
            })
            ->when($id<=265,function($q){
                $q->where('status','passive');
            })
            ->first();

        // return view('group');

        $pdf = App::make('dompdf.wrapper');

        $customPaper = [0, 0, 1100, 800];
        $pdf->setPaper($customPaper);

        //  $pdf->render();
        // $pdf->SetXY(30, 30);

        $pdf->loadView(
            'group',
            compact(
                'students',
                'agains_students',
                'title',
                'criterias',
                'rais',
                'rais_assistant',
                'commissions'
            )
        );
        //  $pdf->setPaper('A4','landscape');
        //  $pdf->render();
        // return $pdf->stream();
        // return view('group', compact(
        //         'students',
        //         'agains_students',
        //         'title',
        //         'criterias',
        //         'rais',
        //         'rais_assistant',
        //         'commissions'
        // ));

        // return view(
        //     'group',
        //     compact(
        //         'students',
        //         'agains_students',
        //         'title',
        //         'criterias',
        //         'rais',
        //         'rais_assistant',
        //         'commissions'
        //     )
        // );

        // try {
        return $pdf->download($file_name);
        // } catch (ClientException $e) {
        //     return $e->getResponse();
        // }
    }

    public function certificate($login)
    {
        if ($login) {
            $student = Student::where('login', $login)->first();
            if ($student) {
                return response()->download(public_path($this->file . $student->certificate));
            }
            $this->error(401 , "Sizga ruxsat yoq");
        }
    }
}
