<?php

namespace App\Http\Controllers;

use App\Imports\GroupImport;
use App\Models\CommissionGroup;
use App\Models\Criteria;
use App\Models\Direction;
use App\Models\Group;
use App\Models\Student;
use App\Models\StudentBall;
use App\Models\User;
use GMP;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator as FacadesValidator;
use Maatwebsite\Excel\Facades\Excel;

class GroupController extends Controller
{
    public function create(Request $request, $id = null)
    {
        if ($id) {
            $this->validationId('group', $id);
            $this->validationId('direction', $request->direction_id);

            $group = Group::find($id);

            $validator = FacadesValidator::make($request->all(), $group->rules);

            if ($validator->fails()) {
                $this->error($validator->errors(), 400);
            }

            $group->fill($request->all());
            $group->save();

            return response([
                'message' => 'Guruh yangilandi',
            ]);
        }
        $group = new Group();
        $this->validationId('direction', $request->direction_id);

        $validator = FacadesValidator::make($request->all(), $group->rules);

        if ($validator->fails()) {
            $this->error($validator->errors(), 400);
        }

        $count = Group::where('direction_id', $request->direction_id)
            ->where('date', strtotime('01.' . $request->date))
            ->where('date_end', strtotime('01.' . $request->date_end))
            ->where('status', '!=', 'delete')
            ->count();

        if ($count == 1) {
            $old_group = Group::where('direction_id', $request->direction_id)
                ->where('date', strtotime('01.' . $request->date))
                ->where('date_end', strtotime('01.' . $request->date_end))
                ->first();

            $old_group->type = 'A';
            $old_group->save();

            $group->type = 'B';
        } elseif ($count > 1) {
            $group->type = chr(65 + $count);
        }

        $group->direction_id = $request->direction_id;
        $group->date = strtotime('01.' . $request->date);
        $group->date_end = strtotime('01.' . $request->date_end);

        $group->save();

        return $group->id;
    }

    public function view(Request $request, $id = null)
    {
        $json = [];
        if ($id) {
            $group_name = Group::find($id);
            $direction_name = Direction::find($group_name->direction_id);

            $students = Student::where('group_id', $id)
                ->where('status', '!=', 'delete')
                ->orderByDesc('id')
                ->get();
            $object_group = (object) [];
            $object_group->id = $id;
            $object_group->name =
                date('m.Y', $group_name->date) .
                ' - ' .
                date('m.Y', $group_name->date_end) .
                ' ' .
                $direction_name->name;
            if ($group_name->type) {
                $object_group->name =
                    date('m.Y', $group_name->date) .
                    ' - ' .
                    date('m.Y', $group_name->date_end) .
                    ' ' . $group_name->type . '.' .
                    $direction_name->name;
            }
            $object_group->student_count = Student::where('group_id', $id)
                ->where('status', '!=', 'delete')
                ->count();

            // $commission_count = CommissionGroup::where('group_id', $id)
            //     ->where('status', 'active')
            //     ->count();

            // if (!$commission_count) {
            //     $commission_count = 1;
            // }

            foreach ($students as $student) {
                $object = (object) [];
                $object->id = $student->id;
                $object->group_id = $student->group_id;
                $object->file_name = $student->file_name;
                $object->ppt_name = $student->ppt_name;
                $object->certificate_name = $student->certificate_name;
                $com_ids = CommissionGroup::where('group_id', $student->group_id)
                    ->where('status', 'active')
                    ->pluck('user_id');

                $commission_count = count($com_ids);

                if ($student->type) {
                    $commissionssss = json_decode($student->type); //
                    foreach ($commissionssss as $com) {
                        $i = 0;

                        foreach ($com_ids as $comm) {
                            if ($com->id == $comm) {
                                $i++;
                            }
                        }
                        if ($i == 0) {
                            $commission_count++;
                        }
                    }
                }
                if (!$commission_count) {
                    $commission_count = 1;
                }

                if ($student->file) {
                    $object->file = $this->file_url . $student->file;
                }
                if ($student->ppt) {
                    $object->ppt = $this->file_url . $student->ppt;
                }
                if ($student->certificate) {
                    $object->certificate = $this->file_url . $student->certificate;
                }
                if ($student->again) {
                    $object->again = true;
                } else {
                    $object->again = false;
                }
                $object->name = $student->name;
                $object->login = $student->login;
                $object->status = $student->status;
                $object->professional_ball =
                    (float) $student->professional_ball;
                $object->online_test_ball = (float) $student->online_test_ball;
                $object->nat = StudentBall::where(
                    'student_id',
                    $student->id
                )->get();
                $object->ball = round(
                    (float) round(
                        StudentBall::where('student_id', $student->id)->sum(
                            'ball'
                        ) / $commission_count,
                        2
                    ) +
                        (float) $student->professional_ball +
                        (float) $student->online_test_ball,
                    2
                );

                $cri = StudentBall::where('student_id', $student->id)->first();

                if ($student->professional_ball == 30) {
                    $object->type = 'green';
                } elseif (
                    $student->professional_ball + $student->online_test_ball <
                    44.8
                ) {
                    $object->type = 'black';
                } elseif ($cri) {
                    $ball =
                        StudentBall::where('student_id', $student->id)->sum(
                            'ball'
                        ) / $commission_count;

                    if ($ball >= 11.2) {
                        $object->type = 'green';
                    } else {
                        $object->type = 'red';
                    }
                } else {
                    $object->type = 'white';
                }

                $json[] = $object;
            }

            $object_group->students = $json;

            return $object_group;
        }
        if (isset($request->date) && isset($request->date_end)) {
            $date = strtotime('01.' . $request->date);
            $date_end = strtotime('01.' . $request->date_end);

            // return $date . $date_end;
            $groups = Group::where('date_end', '=', $date_end)
                ->where('date', '=', $date)
                ->where('status', '!=', 'delete')
                ->orderByDesc('id')
                ->get();
        } elseif (isset($request->date)) {
            $date = strtotime('01.' . $request->date);

            $groups = Group::where('date_end', $date)
                ->where('status', '!=', 'delete')
                ->orderByDesc('id')
                ->get();
        } else {
            $date = strtotime('01.' . date('m.Y', time()));

            $groups = Group::where('date_end', $date)
                ->where('status', '!=', 'delete')
                ->orderByDesc('id')
                ->get();
        }

        foreach ($groups as $group) {
            $commission_group_count = CommissionGroup::where(
                'group_id',
                $group->id
            )
                ->where('status', 'passive')
                ->count();
            $commission_group_done_count = CommissionGroup::where(
                'group_id',
                $group->id
            )
                ->where('status', 'active')
                ->count();

            $object = (object) [];
            $object->id = $group->id;
            $object->direction_id = $group->direction_id;
            $object->direction_name = Direction::where(
                'id',
                $group->direction_id
            )->first()->name;
            if ($group->type) {
                $object->direction_name =
                    $group->type .
                    '.' .
                    Direction::where('id', $group->direction_id)->first()->name;
            }
            $object->status = $group->status;

            $object->date = date('m.Y', $group->date);
            $object->date_end = date('m.Y', $group->date_end);
            $object->student_count = Student::where('group_id', $group->id)
                ->where('status', '!=', 'delete')
                ->count();
            if (
                $commission_group_done_count == $commission_group_count &&
                $object->student_count != 0
            ) {
                $object->status = 'done';
            }

            $json[] = $object;
        }
        return $json;
    }

    public function import(Request $request)
    {
        $this->validationId('group', $request->id);

        Excel::import(new GroupImport($request->id), $request->file('file'));

        return response([
            'message' => 'Muvaffaqiyatli yuklandi',
        ]);
    }

    public function download($id)
    {
        // # pdf download
        $this->validationId('group', $id);

        $title = (object) [];
        $group = Group::find($id);
        $direction = Direction::find($group->direction_id);
        $date = date('m.Y', $group->date);

        $file_name = $date . ' ' . $direction->name . '.pdf';

        $year = explode('.', $date)[1];
        $mount1 = $this->getMounthName(date('m', $group->date)) . '-';
        $mount2 =
            $this->getMounthName(date('m', $group->date_end)) . ' oylarida';
        if (date('m', $group->date) == date('m', $group->date_end)) {
            $mount2 = ' oyida';
            $mount1 = $this->getMounthName(date('m', $group->date));
        }

        $title->title = $direction->name;
        $title->date = $year . '-yil ' . $mount1 . $mount2;
        $students = Student::select(
            DB::raw(
                'id, round(professional_ball + online_test_ball , 3) as result'
            )
        )
            ->where('group_id', $group->id)
            ->where('status', '!=', 'delete')
            ->where('again', 0)
            ->having('result', '>=', 44.8)
            ->get();

        $ids = $this->array($students, 'id');

        $studentss = Student::where('group_id', $group->id)
            ->where('status', '!=', 'delete')
            ->where('again', 0)
            ->where('professional_ball', 30)
            ->orWhereIn('id', $ids)
            ->orderByDesc('id')
            ->get();

        $students_again = Student::select(
            DB::raw(
                'id, round(professional_ball + online_test_ball , 3) as result'
            )
        )
            ->where('group_id', $group->id)
            ->where('status', '!=', 'delete')
            ->where('again', 1)
            ->having('result', '>=', 44.8)
            ->get();

        $ids = $this->array($students_again, 'id');

        $studentss_again = Student::where('group_id', $group->id)
            ->where('status', '!=', 'delete')
            ->where('again', 1)
            ->where('professional_ball', 30)
            ->orWhereIn('id', $ids)
            ->orderByDesc('id')
            ->get();

        $commissions = CommissionGroup::leftjoin(
            'user',
            'user.id',
            '=',
            'commission_group.user_id'
        )
            ->where('commission_group.group_id', $id)
            ->where('user.role', 'commission')
            ->where('commission_group.status', 'active')
            ->pluck('commission_group.user_id');

        // $commission_groupp = CommissionGroup::leftjoin(
        //     'user',
        //     'user.id',
        //     '=',
        //     'commission_group.user_id'
        // )
        //     ->where('commission_group.group_id', $id)
        //     ->where('user.role', 'commission')
        //     ->where('commission_group.status', 'active')
        //     ->pluck('user.id');
        $commission_group_ids = $commissions;
        $commission_group_idss = $commissions;
//        $commissions;
        $student_ids = Student::where('group_id', $id)->where('status', 'active')->where('type', '!=', NULL)->pluck('type');
        foreach ($student_ids as $student_id) {
            $commissionss = json_decode($student_id); //
            foreach ($commissionss as $com) {
                $i = 0;
                foreach ($commissions as $comm) {
                    if ($com->id == $comm) {
                        $i++;
                    }
                }
                if ($i == 0) {
                    $commission_group_ids[] = $com->id;
                }
            }
        }

        $criterias = Criteria::get();
        $string = '';

        $i = 1;

        $students = [];
        foreach ($studentss as $student) {
            $com_ids = CommissionGroup::where('group_id', $group->id)
                ->where('status', 'active')
                ->pluck('user_id');

            $commission_count = count($com_ids);

            if ($student->type) {
                $commissionssss = json_decode($student->type); //
                foreach ($commissionssss as $com) {
                    $i = 0;

                    foreach ($com_ids as $comm) {
                        if ($com->id == $comm) {
                            $i++;
                        }
                    }
                    if ($i == 0) {
                        $commission_count++;
                    }
                }
            }
            if (!$commission_count) {
                $commission_count = 1;
            }

            $object = (object) [];
            $object->name = $student->name;
            $object->professional_ball = $student->professional_ball;
            $object->online_test_ball = $student->online_test_ball;
            $son = round(
                StudentBall::where('student_id', $student->id)->sum('ball') /
                    $commission_count,
                2
            );
            $cri = StudentBall::where('student_id', $student->id)->first();

            $object->cri = false;

            if ($cri) {
                $object->cri = true;
            }
            $object->average = $son;

            $jami = 0;
            $all_son = 0;
            $j = 1;
            foreach ($criterias as $criteria) {
                $val = 'ball_' . $j;
                $ball = StudentBall::where('student_id', $student->id)
                    ->where('criteria_id', $criteria->id)
                    ->first();
                if ($ball) {
                    $son = round(
                        StudentBall::where('student_id', $student->id)
                            ->where('criteria_id', $criteria->id)
                            ->sum('ball') / $commission_count,
                        2
                    );

                    $all_son += $son;
                    $object->$val = $son;
                }

                $j++;
            }

            $jami =
                $all_son +
                $student->professional_ball +
                $student->online_test_ball;

            $object->all_sum = $jami;
            $object->sum = $all_son;
            $i++;
            $students[] = $object;
        }
        $agains_students = [];
        foreach ($studentss_again as $student) {
            $com_ids = CommissionGroup::where('group_id', $group->id)
                ->where('status', 'active')
                ->pluck('user_id');

            $commission_count = count($com_ids);

            if ($student->type) {
                $commissionssss = json_decode($student->type); //
                foreach ($commissionssss as $com) {
                    $i = 0;

                    foreach ($com_ids as $comm) {
                        if ($com->id == $comm) {
                            $i++;
                        }
                    }
                    if ($i == 0) {
                        $commission_count++;
                    }
                }
            }
            if (!$commission_count) {
                $commission_count = 1;
            }

            $object = (object) [];
            $object->name = $student->name;
            $object->professional_ball = $student->professional_ball;
            $object->online_test_ball = $student->online_test_ball;

            $son = round(
                StudentBall::where('student_id', $student->id)->sum('ball') /
                    $commission_count,
                2
            );
            $cri = StudentBall::where('student_id', $student->id)->first();

            $object->cri = false;

            if ($cri) {
                $object->cri = true;
            }
            $object->average = $son;

            $jami = 0;
            $all_son = 0;
            $j = 1;
            foreach ($criterias as $criteria) {
                $val = 'ball_' . $j;
                $ball = StudentBall::where('student_id', $student->id)
                    ->where('criteria_id', $criteria->id)
                    ->first();
                if ($ball) {
                    $son = round(
                        StudentBall::where('student_id', $student->id)
                            ->where('criteria_id', $criteria->id)
                            ->sum('ball') / $commission_count,
                        2
                    );

                    $all_son += $son;
                    $object->$val = $son;
                }

                $j++;
            }

            $jami =
                $all_son +
                $student->professional_ball +
                $student->online_test_ball;

            $object->all_sum = $jami;
            $object->sum = $all_son;
            $i++;
            $agains_students[] = $object;
        }

        $rais = User::where('role', 'director')
            ->where('type', 'rais')
            ->first();
        $rais_assistant = User::where('role', 'director')
            ->where('type', 'assistant')
            ->when($id>265,function($q){
                $q->where('status','active');
            })
            ->when($id<=265,function($q){
                $q->where('status','passive');
            })
            ->first();
        $commissions = User::whereIn('id', $commission_group_ids)->whereNotIn('id',[$rais?->id,$rais_assistant?->id])->get();
        // return view('group');

        $pdf = App::make('dompdf.wrapper');

        $customPaper = [0, 0, 1100, 900];
        $pdf->setPaper($customPaper);

        //  $pdf->render();
        // $pdf->SetXY(30, 30);

        $pdf->loadView(
            'group',
            compact(
                'students',
                'agains_students',
                'title',
                'criterias',
                'rais',
                'rais_assistant',
                'commissions'
            )
        );
        //  $pdf->setPaper('A4','landscape');
        //  $pdf->render();
        // return $pdf->stream();
        // return view('group', compact(
        //         'students',
        //         'agains_students',
        //         'title',
        //         'criterias',
        //         'rais',
        //         'rais_assistant',
        //         'commissions'
        // ));

        // return view(
        //     'group',
        //     compact(
        //         'students',
        //         'agains_students',
        //         'title',
        //         'criterias',
        //         'rais',
        //         'rais_assistant',
        //         'commissions'
        //     )
        // );

        return $pdf->download($file_name);

        // Work download
        // $templateProcessor = new TemplateProcessor('template.docx');

        //     $this->validationId('group', $id);
        //     $group = Group::find($id);
        //     $direction = Direction::find($group->direction_id);

        //     $file_name = $group->date . ' ' . $direction->name . '.docx';

        //     $year = explode('-', $group->date)[1];
        //     $mount1 = $this->getMounthName(explode('-', $group->date)[0]);
        //     $mount2 = $this->getMounthName(explode('-', $group->date)[0] + 1);

        //     $students = Student::select(
        //         DB::raw(
        //             'id, round(professional_ball + online_test_ball , 3) as result'
        //         )
        //     )
        //         ->where('group_id', $group->id)
        //         ->where('status', '!=', 'delete')
        //         ->where('again', 0)
        //         ->having('result', '>=', 44.8)
        //         ->get();

        //     $ids = $this->array($students, 'id');

        //     $studentss = Student::where('group_id', $group->id)
        //         ->where('status', '!=', 'delete')
        //         ->where('again', 0)
        //         ->where('professional_ball', 30)
        //         ->orWhereIn('id', $ids)
        //         ->orderByDesc('id')
        //         ->get();

        //     $students_again = Student::select(
        //         DB::raw(
        //             'id, round(professional_ball + online_test_ball , 3) as result'
        //         )
        //     )
        //         ->where('group_id', $group->id)
        //         ->where('status', '!=', 'delete')
        //         ->where('again', 1)
        //         ->having('result', '>=', 44.8)
        //         ->get();

        //     $ids = $this->array($students_again, 'id');

        //     $studentss_again = Student::where('group_id', $group->id)
        //         ->where('status', '!=', 'delete')
        //         ->where('again', 1)
        //         ->where('professional_ball', 30)
        //         ->orWhereIn('id', $ids)
        //         ->orderByDesc('id')
        //         ->get();

        //     $commission_count = CommissionGroup::leftjoin(
        //         'user',
        //         'user.id',
        //         '=',
        //         'commission_group.user_id'
        //     )
        //         ->where('commission_group.group_id', $id)
        //         ->where('user.role', '!=', 'admin')
        //         ->count();
        //     $commissions = CommissionGroup::leftjoin(
        //         'user',
        //         'user.id',
        //         '=',
        //         'commission_group.user_id'
        //     )
        //         ->where('commission_group.group_id', $id)
        //         ->where('user.role', 'commission')
        //         ->get();

        //     $templateProcessor->setValue(
        //         'date',
        //         $year . '-yil ' . $mount1 . '-' . $mount2 . ' '
        //     );
        //     $templateProcessor->setValue('title', $direction->name);

        //     $cloneCount = count($studentss);
        //     $templateProcessor->cloneRow('id', $cloneCount);

        //     $cloneCount_again = count($studentss_again);
        //     $templateProcessor->cloneRow('again', $cloneCount_again);

        //     if ($commission_count == 0) {
        //         $commission_count = 1;
        //     }

        //     $criterias = Criteria::get();
        //     $string = '';

        //     $i = 1;

        //     foreach ($studentss as $student) {
        //         $son = round(
        //             StudentBall::where('student_id', $student->id)->sum('ball') /
        //                 $commission_count,
        //             2
        //         );
        //         $cri = StudentBall::where('student_id', $student->id)->first();
        //         $templateProcessor->setValue('id#' . $i, $i);
        //         $templateProcessor->setValue('name#' . $i, $student->name);
        //         $templateProcessor->setValue(
        //             'k#' . $i,
        //             $student->professional_ball
        //         );
        //         if ($student->professional_ball == 30) {
        //             $templateProcessor->setValue('o#' . $i, '');
        //             $templateProcessor->setValue('bj#' . $i, ' ');
        //             $templateProcessor->setValue('bu#' . $i, 'Ijobiy');
        //             $j = 1;
        //             foreach ($criterias as $criteria) {
        //                 $templateProcessor->setValue('b' . $j . '#' . $i, ' ');
        //                 $j++;
        //             }
        //         } elseif ($cri && $son < 11.2) {
        //             if ($son < 11.2) {
        //                 $templateProcessor->setValue(
        //                     'o#' . $i,
        //                     $student->online_test_ball
        //                 );

        //                 $jami = 0;
        //                 $all_son = 0;
        //                 $j = 1;
        //                 foreach ($criterias as $criteria) {
        //                     $ball = StudentBall::where('student_id', $student->id)
        //                         ->where('criteria_id', $criteria->id)
        //                         ->first();
        //                     if ($ball) {
        //                         $son = round(
        //                             StudentBall::where('student_id', $student->id)
        //                                 ->where('criteria_id', $criteria->id)
        //                                 ->sum('ball') / $commission_count,
        //                             2
        //                         );

        //                         $all_son += $son;
        //                     } else {
        //                         $all_son = 0;
        //                         $son = '';
        //                     }

        //                     $templateProcessor->setValue('b' . $j . '#' . $i, $son);
        //                     $j++;
        //                 }

        //                 $jami =
        //                     $all_son +
        //                     $student->professional_ball +
        //                     $student->online_test_ball;

        //                 $templateProcessor->setValue(
        //                     'bj#' . $i,
        //                     $all_son . ' ball'
        //                 );
        //                 $templateProcessor->setValue(
        //                     'bu#' . $i,
        //                     "Attestatsiyadan o'tmadi"
        //                 );
        //             }
        //         } elseif ($cri && $son >= 11.2) {
        //             $templateProcessor->setValue(
        //                 'o#' . $i,
        //                 $student->online_test_ball
        //             );

        //             $jami = 0;
        //             $all_son = 0;
        //             $j = 1;
        //             foreach ($criterias as $criteria) {
        //                 $ball = StudentBall::where('student_id', $student->id)
        //                     ->where('criteria_id', $criteria->id)
        //                     ->first();
        //                 if ($ball) {
        //                     $son = round(
        //                         StudentBall::where('student_id', $student->id)
        //                             ->where('criteria_id', $criteria->id)
        //                             ->sum('ball') / $commission_count,
        //                         2
        //                     );

        //                     $all_son += $son;
        //                 } else {
        //                     $all_son = 0;
        //                     $son = '';
        //                 }

        //                 $templateProcessor->setValue('b' . $j . '#' . $i, $son);
        //                 $j++;
        //             }

        //             $jami =
        //                 $all_son +
        //                 $student->professional_ball +
        //                 $student->online_test_ball;

        //             $templateProcessor->setValue('bj#' . $i, $all_son . ' ball');
        //             $templateProcessor->setValue('bu#' . $i, $jami . ' ball');
        //         } else {
        //             $templateProcessor->setValue(
        //                 'o#' . $i,
        //                 $student->online_test_ball
        //             );

        //             $jami = 0;
        //             $j = 1;
        //             foreach ($criterias as $criteria) {
        //                 $templateProcessor->setValue('b' . $j . '#' . $i, ' ');
        //                 $j++;
        //             }

        //             $jami =
        //                 $student->professional_ball + $student->online_test_ball;

        //             $templateProcessor->setValue('bj#' . $i, ' ');
        //             $templateProcessor->setValue('bu#' . $i, $jami . ' ball');
        //         }

        //         $i++;
        //     }

        //     $i = 1;

        //     foreach ($studentss_again as $student) {
        //         $son = round(
        //             StudentBall::where('student_id', $student->id)->sum('ball') /
        //                 $commission_count,
        //             2
        //         );
        //         $cri = StudentBall::where('student_id', $student->id)->first();
        //         $templateProcessor->setValue('again#' . $i, $i);
        //         $templateProcessor->setValue('aname#' . $i, $student->name);
        //         $templateProcessor->setValue(
        //             'ak#' . $i,
        //             $student->professional_ball
        //         );
        //         if ($student->professional_ball == 30) {
        //             $templateProcessor->setValue('ao#' . $i, '');
        //             $templateProcessor->setValue('abj#' . $i, ' ');
        //             $templateProcessor->setValue('abu#' . $i, 'Ijobiy');
        //             $j = 1;
        //             foreach ($criterias as $criteria) {
        //                 $templateProcessor->setValue('ab' . $j . '#' . $i, ' ');
        //                 $j++;
        //             }
        //         } elseif ($cri && $son < 11.2) {
        //             if ($son < 11.2) {
        //                 $templateProcessor->setValue(
        //                     'ao#' . $i,
        //                     $student->online_test_ball
        //                 );

        //                 $jami = 0;
        //                 $all_son = 0;
        //                 $j = 1;
        //                 foreach ($criterias as $criteria) {
        //                     $ball = StudentBall::where('student_id', $student->id)
        //                         ->where('criteria_id', $criteria->id)
        //                         ->first();
        //                     if ($ball) {
        //                         $son = round(
        //                             StudentBall::where('student_id', $student->id)
        //                                 ->where('criteria_id', $criteria->id)
        //                                 ->sum('ball') / $commission_count,
        //                             2
        //                         );

        //                         $all_son += $son;
        //                     } else {
        //                         $all_son = 0;
        //                         $son = '';
        //                     }

        //                     $templateProcessor->setValue('ab' . $j . '#' . $i, $son);
        //                     $j++;
        //                 }

        //                 $jami =
        //                     $all_son +
        //                     $student->professional_ball +
        //                     $student->online_test_ball;

        //                 $templateProcessor->setValue(
        //                     'abj#' . $i,
        //                     $all_son . ' ball'
        //                 );
        //                 $templateProcessor->setValue(
        //                     'abu#' . $i,
        //                     "Attestatsiyadan o'tmadi"
        //                 );
        //             }
        //         } elseif ($cri && $son >= 11.2) {
        //             $templateProcessor->setValue(
        //                 'ao#' . $i,
        //                 $student->online_test_ball
        //             );

        //             $jami = 0;
        //             $all_son = 0;
        //             $j = 1;
        //             foreach ($criterias as $criteria) {
        //                 $ball = StudentBall::where('student_id', $student->id)
        //                     ->where('criteria_id', $criteria->id)
        //                     ->first();
        //                 if ($ball) {
        //                     $son = round(
        //                         StudentBall::where('student_id', $student->id)
        //                             ->where('criteria_id', $criteria->id)
        //                             ->sum('ball') / $commission_count,
        //                         2
        //                     );

        //                     $all_son += $son;
        //                 } else {
        //                     $all_son = 0;
        //                     $son = '';
        //                 }

        //                 $templateProcessor->setValue('ab' . $j . '#' . $i, $son);
        //                 $j++;
        //             }

        //             $jami =
        //                 $all_son +
        //                 $student->professional_ball +
        //                 $student->online_test_ball;

        //             $templateProcessor->setValue('abj#' . $i, $all_son . ' ball');
        //             $templateProcessor->setValue('abu#' . $i, $jami . ' ball');
        //         } else {
        //             $templateProcessor->setValue(
        //                 'ao#' . $i,
        //                 $student->online_test_ball
        //             );

        //             $jami = 0;
        //             $j = 1;
        //             foreach ($criterias as $criteria) {
        //                 $templateProcessor->setValue('ab' . $j . '#' . $i, ' ');
        //                 $j++;
        //             }

        //             $jami =
        //                 $student->professional_ball + $student->online_test_ball;

        //             $templateProcessor->setValue('abj#' . $i, ' ');
        //             $templateProcessor->setValue('abu#' . $i, $jami . ' ball');
        //         }

        //         $i++;
        //     }

        //     $rais = User::where('role', 'director')
        //         ->where('type', 'rais')
        //         ->first();
        //     $rais_assistant = User::where('role', 'director')
        //         ->where('type', 'assistant')
        //         ->first();
        //     if ($rais) {
        //         $templateProcessor->setValue('rais', $rais->name);
        //     }
        //     if ($rais_assistant) {
        //         $templateProcessor->setValue('raiso', $rais_assistant->name);
        //     }
        //     $templateProcessor->cloneRow('com', $commission_count-2);

        //     $i = 1;
        //     foreach ($commissions as $commission) {
        //         $commission = User::find($commission->user_id);
        //         $templateProcessor->setValue('com#' . $i, $commission->name);

        //         $i++;
        //     }

        //     $templateProcessor->saveAs($file_name . '.docx');
        //     return response()
        //         ->download($file_name . '.docx')
        //         ->deleteFileAfterSend(true);
    }

    public function attach(Request $request)
    {
        $this->validationId('group', $request->group_id);
        if (!isset($request->user_id)) {
            CommissionGroup::where('group_id', $request->group_id)
                ->where('status', 'active')
                ->delete();
            $commissions = User::where('role', '!=', 'admin')->where('status','active')->get();
            foreach ($commissions as $commission) {
                $commission_group = new CommissionGroup();
                $commission_group->group_id = $request->group_id;
                $commission_group->user_id = $commission->id;

                $commission_group->save();
            }

            return response([
                'message' => 'Muvaffaqiyatli biriktirildi',
            ]);
        }
        $this->validationId('user', $request->user_id);

        $commission_group = CommissionGroup::where('user_id', $request->user_id)
            ->where('group_id', $request->group_id)
            ->where('status', 'active')
            ->first();
        if ($commission_group) {
            $commission_group->delete();
            return response([
                'message' => "Muvaffaqiyatli o'zgartirildi",
            ]);
        }
        $commission_group = new CommissionGroup();

        $validator = FacadesValidator::make(
            $request->all(),
            $commission_group->rules
        );

        if ($validator->fails()) {
            $this->error($validator->errors(), 400);
        }

        CommissionGroup::create($request->all());

        return response([
            'message' => 'Muvaffaqiyatli biriktirildi',
        ]);
    }

    public function groupDelete($id)
    {
        $this->validationId('group', $id);

        $student_count = Student::where('status', 'active')
            ->where('group_id', $id)
            ->count();
        if ($student_count == 0) {
            $group = Group::find($id);
            $group->status = 'delete';
            $group->save();

            return response([
                'message' => "Muvaffaqiyatli o'chirildi",
            ]);
        }

        $this->error("O'chirish imkonsiz", 400);
    }

    public function groupDate()
    {
        $groups = Group::where('status', '!=', 'delete')
            ->orderByDesc('date_end')
            ->get();

        $array_date = [];

        foreach ($groups as $group) {
            $data =
                date('m.Y', $group->date) .
                ' - ' .
                date('m.Y', $group->date_end);
            if (!in_array($data, $array_date)) {
                $array_date[] = $data;
            }
        }
        return $array_date;
    }
}
