<?php

namespace App\Http\Controllers;

use App\Models\Arxiv;
use App\Models\Change;
use App\Models\CommissionGroup;
use App\Models\Criteria;
use App\Models\Student;
use App\Models\StudentBall;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class StudentBallController extends Controller
{
    public function view(Request $request, $id)
    {
        $user = $this->getUser($request);

        $this->validationId('student', $id);

        $student = Student::find($id);
        $object = (object) [];
        $json = [];
        $criterias = StudentBall::select(
            DB::raw(
                'criteria.id as id ,criteria.name as name,criteria.max_ball as max_ball ,criteria.description as description , student_ball.ball as ball'
            )
        )
            ->leftjoin(
                'criteria',
                'criteria.id',
                '=',
                'student_ball.criteria_id'
            )
            ->where('student_ball.user_id', $user->id)
            ->where('student_ball.student_id', $id)
            ->get();

        if ($criterias != '[]') {
            $criterias_json = [];
            foreach ($criterias as $criteria) {
                $object1 = (object) [];
                $object1->id = $criteria['id'];
                $object1->name = $criteria['name'];
                $object1->max_ball = (float) $criteria['max_ball'];
                $object1->description = $criteria['description'];
                $object1->ball = round((float) $criteria['ball'], 2);
                $criterias_json[] = $object1;
            }
            $object->criteria = $criterias_json;
        } else {
            $criterias = Criteria::get();
            foreach ($criterias as $criteria) {
                $obj = (object) [];

                $obj->id = $criteria->id;
                $obj->name = $criteria->name;
                $obj->max_ball = (float) $criteria->max_ball;
                $obj->description = $criteria->description;
                $obj->ball = 0;

                $json[] = $obj;
            }
            $object->criteria = $json;
        }
        $object->id = $student->id;
        $object->name = $student->name;
        if ($student->type) {
            $type = $this->array(json_decode($student->type), 'id');
            if (in_array($user->id, $type)) {
                $object->status = 'done';
            } else {
                $object->status = 'doing';
            }
        } else {
            $object->status = 'doing';
        }

        $object->file_name = $student->file_name;
        $object->file = $this->file_url . $student->file;
        $object->ppt_name = $student->ppt_name;
        $object->ppt = $this->file_url . $student->ppt;

        return $object;
    }

    public function create(Request $request)
    {
        $user = $this->getUser($request);

        $this->validationId('student', $request->student_id);

        foreach ($request['criteria_ids'] as $id) {
            $criteria = StudentBall::where('criteria_id', $id['criteria_id'])
                ->where('student_id', $request->student_id)
                ->where('user_id', $user->id)
                ->first();

            if ($criteria) {
                $this->error("O'zgartirish imkonsiz", 403);
            }

            $criteria = new StudentBall();

            $criteria->ball = $id['ball'];
            $criteria->user_id = $user->id;
            $criteria->criteria_id = $id['criteria_id'];
            $criteria->student_id = $request->student_id;

            $criteria->save();
        }

        $student = Student::find($request->student_id);
        $criteria_count = Criteria::count();

        $student_group_count = Student::select(
            DB::raw('round(professional_ball + online_test_ball , 3) as result')
        )
            ->where('group_id', $student->group_id)
            ->where('status', 'active')
            ->where('professional_ball', '!=', 30)
            ->having('result', '>=', 44.8)
            ->count();

        $student_group_ids = Student::where('group_id', $student->group_id)
            ->where('status', 'active')
            ->pluck('id')
            ->toArray();
        $student_ball_count = StudentBall::where('user_id', $user->id)
            ->whereIn('student_id', $student_group_ids)
            ->count();

        if ($student_ball_count / $criteria_count >= $student_group_count) {
            $commission_group = new CommissionGroup();
            $commission_group->group_id = $student->group_id;
            $commission_group->user_id = $user->id;
            $commission_group->status = 'passive';
            $commission_group->save();
        }

        $json = [];
        $student = Student::find($request->student_id);
        if ($student->type) {
            $data = json_decode($student->type);
            $object = (object) [];
            $object->id = $user->id;
            $json[] = $object;

            $student->type = json_encode(array_merge($data, $json));
            $student->save();
        } else {
            $object = (object) [];
            $object->id = $user->id;
            $json[] = $object;

            $student->type = json_encode($json);
            $student->save();
        }

        return response([
            'message' => 'Ball saqlandi',
        ]);
    }

    public function info($student_id)
    {
        $result = (object) [];
        $this->validationId('student', $student_id);
        $student = Student::find($student_id);
        $result->student_id = $student->id;
        $result->student_name = $student->name;
        $result->professional_ball = (float) $student->professional_ball;
        $result->online_test_ball = (float) $student->online_test_ball;

        // $director = User::where('role', 'director')->first();
        // $result->director_id = $director->id;
        // $result->director_name = $director->name;
        // $commission_group = CommissionGroup::where(
        //     'group_id',
        //     $student->group_id
        // )
        //     ->where('status', 'active')
        //     ->pluck('user_id');

        $commission_group = CommissionGroup::where(
            'group_id',
            $student->group_id
        )->where('status', 'active')->pluck('user_id');

        $commission_group_ids = $commission_group;

        if ($student->type) {
            $commissionss = json_decode($student->type); //
            foreach ($commissionss as $com) {
                $i=0;

                foreach($commission_group as $comm){
                    if($com->id == $comm){
                        $i++;
                    }

                }
                if ($i==0) {
                    $commission_group_ids [] = $com->id;
                }
            }
        }

        $commissions = User::whereIn('id', $commission_group_ids)->get();

        $commission_count = count($commissions);

        if(!$commission_count){
            $commission_count = 1;

        }
        // if ($student->type) {
        //     $commission_count = count($commissionss);
        // }
        // $com_count = CommissionGroup::where('group_id', $student->group_id)
        //     ->where('status', 'active')
        //     ->count();
        // if ($com_count > $commission_count) {
        //     $commission_count = $com_count;
        // }
        $summa_ball = 0;
        $json_val = [];
        foreach ($commissions as $commission) {
            $object_commission = (object) [];
            $object_commission->commission_id = $commission->id;
            $object_commission->commission_name = $commission->name;
            $json_criteria = [];

            $criterias = StudentBall::select(
                DB::raw(
                    'student_ball.id as id ,criteria.name as name,criteria.max_ball as max_ball ,criteria.description as description , student_ball.ball as ball,student_ball.status as status'
                )
            )
                ->leftjoin(
                    'criteria',
                    'criteria.id',
                    '=',
                    'student_ball.criteria_id'
                )
                ->where('student_ball.student_id', $student_id)
                ->where('student_ball.user_id', $commission->id)
                ->get();
            if ($criterias != '[]') {
                foreach ($criterias as $criteria) {
                    $obj = (object) [];
                    $obj->ball_id = $criteria->id;
                    $obj->criteria_name = $criteria->name;
                    $obj->max_ball = $criteria->max_ball;
                    $obj->description = $criteria->description;
                    $obj->ball = $criteria->ball;
                    $obj->status = $criteria->status;
                    $json_criteria[] = $obj;
                    $summa_ball += $criteria->ball;
                }
            } else {
                $criterias = Criteria::get();

                foreach ($criterias as $criteria) {
                    $obj = (object) [];
                    // $obj->ball_id = $criteria->id;
                    $obj->criteria_name = $criteria->name;
                    $obj->max_ball = $criteria->max_ball;
                    $obj->description = $criteria->description;
                    $obj->ball = 0;
                    $obj->status = 'low';
                    $json_criteria[] = $obj;
                }
            }
            $object_commission->criteria = $json_criteria;

            $json_val[] = $object_commission;
        }
        $result->average_value = round($summa_ball / $commission_count, 2);
        $result->criterias = $json_val;

        $change = Change::where('student_id', $student_id)->first();
        if ($change) {
            if ($change->created_at) {
                $result->date = $change->created_at;
            }
            $result->file_name = $change->file_name;
            $result->file = $this->file_url . $change->file;
        }

        return $result;
    }

    public function editInfo(Request $request, $id = null)
    {
        $user = $this->getUser($request);

        if (isset($request->file) && isset($request->student_id)) {
            $this->validationId('student', $request->student_id);
            $change = Change::where(
                'student_id',
                $request->student_id
            )->first();
            if ($change) {
                if (isset($request->file)) {
                    if ($this->checkFile($request->file)) {
                        $array = explode(
                            '.',
                            $request->file->getClientOriginalName()
                        );
                        $exp = $array[count($array) - 1];

                        $fileName = time() . '.' . $exp;

                        $request->file->move(
                            public_path($this->file),
                            $fileName
                        );
                        $change->file = $fileName;
                        $change->file_name = $request->file->getClientOriginalName();
                    }
                }

                $change->save();
                return response([
                    'message' => "Fayl o'zgartirildi",
                ]);
            }
            $change = new Change();
            $change->student_id = $request->student_id;
            $change->user_id = $user->id;

            if (isset($request->file)) {
                if ($this->checkFile($request->file)) {
                    $array = explode(
                        '.',
                        $request->file->getClientOriginalName()
                    );
                    $exp = $array[count($array) - 1];

                    $fileName = time() . '.' . $exp;

                    $request->file->move(public_path($this->file), $fileName);

                    $change->file = $fileName;
                    $change->file_name = $request->file->getClientOriginalName();
                }
            }
            $change->save();

            return response([
                'message' => 'Fayl saqlandi',
            ]);
        }

        if ($request['ball_ids']) {
            foreach ($request['ball_ids'] as $id) {
                $this->validationId('student_ball', $id['id']);

                $ball = StudentBall::find($id['id']);

                $arxiv = new Arxiv();
                $arxiv->user_id = $user->id;
                $arxiv->student_ball_id = $ball->id;
                $arxiv->ball = $ball->ball;
                $arxiv->change_ball = $id['ball'];
                $arxiv->created_at = date('d.m.Y H:i:s', time());
                $arxiv->save();

                $ball->ball = $id['ball'];
                $ball->status = 'passive';

                $ball->save();
            }

            $change = Change::where('student_id', $ball->student_id)->first();
            if ($change) {
                $change->created_at = time();
                $change->save();
            } else {
                $change = new Change();
                $change->student_id = $ball->student_id;
                $change->user_id = $user->id;
                $change->created_at = time();

                $change->save();
            }

            return response([
                'message' => "Ball o'zgartirildi",
            ]);
        }

        $this->error('Xatolik', 400);
    }
}
