<?php

namespace App\Http\Controllers;

use App\Models\Change;
use App\Models\CommissionGroup;
use App\Models\Group;
use App\Models\Student;
use App\Models\StudentBall;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class StudentController extends Controller
{
    public function create(Request $request, $id = null)
    {
        if ($id) {
            $user = $this->getUser($request);
            $this->validationId('student', $id);
            $this->validationId('group', $request->group_id);

            $student = Student::find($id);

            if ($request->again == 'true') {
                $student->again = 1;
            } else {
                $student->again = 0;
            }
            $student->group_id = $request->group_id;
            $student->name = $request->name;

            # ruhsatga tekshirish start
            $commission_count = CommissionGroup::where(
                'group_id',
                $id
            )->where('status','active')->count();

            if (!$commission_count) {
                $commission_count = 1;
            }

            $cri = StudentBall::where('student_id', $student->id)->first();

            if ($student->professional_ball == 30) {
                $type = 'green';
            } elseif (
                $student->professional_ball + $student->online_test_ball <
                44.8
            ) {
                $type = 'black';
            } elseif ($cri) {
                $ball =
                    StudentBall::where('student_id', $student->id)->sum(
                        'ball'
                    ) / $commission_count;

                if ($ball >= 11.2) {
                    $type = 'green';
                } else {
                    $type = 'red';
                }
            } else {
                $type = 'white';
            }

            if (
                $user->role != 'admin' ||
                $type == 'white' ||
                $type == 'black'
            ) {
                if (isset($request->professional_ball)) {
                    $student->professional_ball = $request->professional_ball;
                }
                if (isset($request->online_test_ball)) {
                    $student->online_test_ball = $request->online_test_ball;
                }
            }

            # ruhsatga tekshirish end

            $validator = FacadesValidator::make(
                $request->all(),
                $student->rules
            );

            if ($validator->fails()) {
                $this->error($validator->errors(), 400);
            }

            $student->login = $request->login;

            if ($request->file != 'null') {
                if ($this->checkFile($request->file)) {
                    $array = explode(
                        '.',
                        $request->file->getClientOriginalName()
                    );
                    $exp = $array[count($array) - 1];

                    $student->file_name = $request->file->getClientOriginalName();

                    $fileName = "f" . time() . '.' . $exp;

                    $request->file->move(public_path($this->file), $fileName);
                    $student->file = $fileName;
                }
            }

            if ($request->ppt != 'null') {
                if ($this->checkFile($request->ppt)) {
                    $array = explode(
                        '.',
                        $request->ppt->getClientOriginalName()
                    );
                    $exp = $array[count($array) - 1];

                    $fileName = "p" . time() . '.' . $exp;

                    $request->ppt->move(public_path($this->file), $fileName);

                    $student->ppt_name = $request->ppt->getClientOriginalName();

                    $student->ppt = $fileName;
                }
            }

            if ($request->certificate != 'null') {
                if ($this->checkFile($request->certificate)) {
                    $array = explode(
                        '.',
                        $request->certificate->getClientOriginalName()
                    );
                    $exp = $array[count($array) - 1];

                    $fileName = "c".time() . '.' . $exp;

                    $request->certificate->move(public_path($this->file), $fileName);

                    $student->certificate_name = $request->certificate->getClientOriginalName();

                    $student->certificate = $fileName;
                }
            }
            
            $student->save();

            return response([
                'message' => 'Tinglovchi yangilandi',
            ]);
        }
        $student = new Student();
        $this->validationId('group', $request->group_id);

        $validator = FacadesValidator::make($request->all(), $student->rules);

        if ($validator->fails()) {
            $this->error($validator->errors(), 400);
        }

        $student = new Student();
        if ($request->again == 'true') {
            $student->again = 1;
        } else {
            $student->again = 0;
        }
        $student->group_id = $request->group_id;
        $student->name = $request->name;
        if (isset($request->professional_ball)) {
            $student->professional_ball = $request->professional_ball;
        }
        if (isset($request->online_test_ball)) {
            $student->online_test_ball = $request->online_test_ball;
        }
        if (isset($request->login)) {
            $student->login = $request->login;
        }

        if ($request->file != 'null') {
            if ($this->checkFile($request->file)) {
                $array = explode('.', $request->file->getClientOriginalName());
                $exp = $array[count($array) - 1];

                $fileName = "f".time() . '.' . $exp;

                $request->file->move(public_path($this->file), $fileName);

                $student->file_name = $request->file->getClientOriginalName();

                $student->file = $fileName;
            }
        }
        if ($request->ppt != 'null') {
            if ($this->checkFile($request->ppt)) {
                $array = explode('.', $request->ppt->getClientOriginalName());
                $exp = $array[count($array) - 1];

                $fileName = "p".time() . '.' . $exp;

                $request->ppt->move(public_path($this->file), $fileName);

                $student->ppt_name = $request->ppt->getClientOriginalName();

                $student->ppt = $fileName;
            }
        }
        if ($request->certificate != 'null') {
            if ($this->checkFile($request->certificate)) {
                $array = explode(
                    '.',
                    $request->certificate->getClientOriginalName()
                );
                $exp = $array[count($array) - 1];

                $fileName = "c".time() . '.' . $exp;

                $request->certificate->move(public_path($this->file), $fileName);

                $student->certificate_name = $request->certificate->getClientOriginalName();

                $student->certificate = $fileName;
            }
        }
        $student->save();
        return response([
            'message' => 'Tinglovchi yaratildi',
        ]);
    }

    public function view($id = null)
    {
        if ($id) {
            return Student::find($id);
        }
        return Student::orderByDesc('id')
            ->where('status', '!=', 'delete')
            ->get();
    }

    public function download($student_id, $type = null)
    {
        $this->validationId('student', $student_id);
        if ($type == 'director') {
            $change = Change::where('student_id', $student_id)->first();
            if ($change->file) {
                return response()->download(
                    public_path($this->file . $change->file)
                );
            }

            return false;
        } elseif ($type == 'ppt') {
            $student = Student::find($student_id);

            if ($student->ppt) {
                return response()->download(
                    public_path($this->file . $student->ppt)
                );
            }
        } elseif ($type == 'doc') {
            $student = Student::find($student_id);

            if ($student->file) {
                return response()->download(
                    public_path($this->file . $student->file)
                );
            }
        }

        return false;
    }
}
