<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{
    public function view($role)
    {
        $user = Cache::remember('user/{role}', 10, function () use ($role) {
            return 12;

            $user = User::where('role', $role)
            ->orderByDesc('id')
                ->paginate(10);
            for ($i = 0; $i < 2000; $i++) {
                $t = User::where('role', $role)
                ->orderByDesc('id')
                    ->get();
            }
            return 12;
        });

        // return 45;
        $object = (object) [];
        $object->data = $user->getCollection();
        $object->total = $user->total();
        $object->current_page = $user->currentPage();

        return $object;
    }
    public function status(Request $request)
    {
        $this->validationId('user', $request->id);
        $user = User::find($request->id);

        $user->status = $request->status;
        $user->save();
        return response([
            'message' => "Status o'zgartirildi",
        ]);
    }

    public function selectCommission($group_id)
    {
        $result = (object) [];
        $json_commission = [];
        $json_rais = [];
        $json_assistant = [];

        $ids = User::leftjoin(
            'commission_group',
            'commission_group.user_id',
            '=',
            'user.id'
        )
            ->where('user.role', '!=', 'admin')
            ->where('commission_group.group_id', $group_id)
            ->where('user.status', 'active')
            ->where('commission_group.status', 'active')
            ->pluck('user.id')
            ->toArray();

        $users = User::select(DB::raw('id,name,type'))
            ->where('role', '!=', 'admin')
            ->where('status', 'active')
            ->orderByDesc('id')
            // ->toArray()
            ->get();
        // return $users;
        foreach ($users as $user) {
            $object = (object) [];
            $object->id = $user->id;
            $object->name = $user->name;
            if (in_array($user->id, $ids)) {
                $object->select = true;
            } else {
                $object->select = false;
            }

            if ($user->type == 'rais') {
                $json_rais[] = $object;
            } elseif ($user->type == 'assistant') {
                $json_assistant[] = $object;
            } else {
                $json_commission[] = $object;
            }
        }

        $result->rais = $json_rais;
        $result->assistant = $json_assistant;
        $result->commission = $json_commission;

        return $result;
    }
}
