<?php

namespace App\Imports;

use App\Models\Student;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class GroupImport implements ToCollection
{
    public function __construct($id)
    {
        $this->group_id = $id;
    }

    public function collection(Collection $rows)
    {
        $i = 0;
        foreach ($rows as $row) {
            if ($row[0] == 1) {
                $i = 1;
            }
            if (!isset($row[2])) {
                $row[2] = 0;
            }
            if (!isset($row[3])) {
                $row[3] = 0;
            }
            if ($i == 1 && $row[1] && $row[2] <= 30 && $row[3] <= 50) {
                Student::create([
                    'group_id' => $this->group_id,
                    'name' => $row[1],
                    'professional_ball' => $row[2],
                    'online_test_ball' => $row[3],
                ]);
            }
        }
    }
}
