<?php

namespace App\Models;

use App\Models\Trouble;
use App\Models\User;
use Illuminate\Support\Facades\Http;

class Eskiz
{
    const ESKIZ_EMAIL = "biznesvnavoi@gmail.com";
    const ESKIZ_PASSWORD = "3GFzxi7XtZ0BS9rpI2LJSoof0fz0shDCZF4TQoq0";
    const ESKIZ_LOGIN_API = "https://notify.eskiz.uz/api/auth/login";
    const ESKIZ_SEND_SMS_API = "https://notify.eskiz.uz/api/message/sms/send";
    const ESKIZ_NIKNAME = "4546";

    public static function updateToken()
    {
        $response = Http::post(self::ESKIZ_LOGIN_API, ['email' => self::ESKIZ_EMAIL, 'password' => self::ESKIZ_PASSWORD]);

        if ($response->successful()) {
            return json_decode($response)->data->token;
        }
        return false;
    }

    public static function changePhoneFormat($phone)
    {
        return preg_replace('/[^0-9]/', '', $phone);
    }

    public static function getToken()
    {
        $file = public_path('eskiz_access_token.json');
        $data = json_decode(file_get_contents($file));

        if (time() > $data->due_at) {
            $access_token = self::updateToken();
            if ($access_token) {
                $data->access_token = $access_token;
                $data->due_at = time() + 86400;
                file_put_contents($file, json_encode($data));
                return $access_token;
            }
        }

        return $data->access_token;
    }

    public static function send($phone, $text)
    {
        $response = Http::withHeaders([
            'Authorization' => "Bearer " . self::getToken(),
        ])->post(self::ESKIZ_SEND_SMS_API, [
            'mobile_phone' => self::changePhoneFormat($phone),
            'message' => $text,
            'from' => self::ESKIZ_NIKNAME,
        ]);

        return json_decode($response);
    }
}
