<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    use HasFactory;
    protected $table = 'student';
    public $timestamps = false;

    public   $rules = [
        'name' => ['required', 'max:100'],
        'login' => ['max:50'],
        'group_id' => ['required', 'integer'],
    ];

    protected $fillable = ['name', 'group_id', 'again', 'file', 'ppt', 'login', 'certificate', 'ppt_name', 'certificate_name', 'description', 'status', 'file_name', 'professional_ball', 'online_test_ball'];
    protected $guarded = ['id'];
}
